package com.biz.crm.nebular.sfa.freesignconfig.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 签到组-打卡人员 请求vo
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaFreesignPersonnelReqVo", description = "签到组-打卡人员 ")
public class SfaFreesignPersonnelReqVo extends CrmBaseVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("编码 编码")
    private String personnelCode;

    @ApiModelProperty("名称 名称")
    private String personnelName;

    @ApiModelProperty("类型 类型(1:组织类型;2:组织;3:人员)")
    private String personnelType;

    @ApiModelProperty("组织范围 组织范围(10:当前组织;20:当前组织及下级组织)")
    private String orgRange;

    @ApiModelProperty("范围类型 范围类型(1:包含;2:非包含;)")
    private String rangeType;

    @ApiModelProperty("签到组编码 签到组编码")
    private String freesignCode;

    @ApiModelProperty("签到组编码集合 签到组编码集合")
    private List<String> freesignCodes;

    private String ext1 = StringUtils.EMPTY;

    private String ext2 = StringUtils.EMPTY;

    private String ext3 = StringUtils.EMPTY;

    private String ext4 = StringUtils.EMPTY;

    private String ext5 = StringUtils.EMPTY;

    private String ext6 = StringUtils.EMPTY;

    private String ext7 = StringUtils.EMPTY;

    private String ext8 = StringUtils.EMPTY;

    private String ext9 = StringUtils.EMPTY;

    private String ext10 = StringUtils.EMPTY;

}