package com.biz.crm.nebular.mdm.cusorg;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 客户组织条件查询请求
 *
 * @author zxw
 * @date 2020-11-03 23:35
 **/
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
@ApiModel("客户组织条件查询请求")
public class MdmCustomerOrgConditionReqVo {

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织编码集合")
    private List<String> customerOrgCodeList;

    @ApiModelProperty(value = "客户组织名称")
    private String customerOrgName;

    @ApiModelProperty(value = "客户组织层级")
    private String customerOrgLevel;

    @ApiModelProperty(value = "客户组织类型")
    private String customerOrgType;

    @ApiModelProperty("状态")
    private String enableStatus;

    @ApiModelProperty("物化规则编码集合")
    private List<String> ruleCodeList;

    @ApiModelProperty("物化规则编码")
    private String ruleCode;

}
