package com.biz.crm.nebular.mdm.notice.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 *
 * 小程序端公告列表
 *
 * @Author hej
 * @Created Date 2020-11-25
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaNoticeMiniReqVo", description = "公告列表 ")
public class MdmNoticeMiniReqVo extends CrmBaseVo {

    @ApiModelProperty("上级组织Code")
    private String superCode;

    @ApiModelProperty("公告标题")
    private String noticeTitle;

    @ApiModelProperty("本身的组织Code")
    private String thisCode;

    @ApiModelProperty("登陆人账号")
    private String userName;

    @ApiModelProperty("登陆人岗位")
    private String thisPost;

    @ApiModelProperty("当前组织的所有下级组织")
    private List<String> orgs;



}
