package com.biz.crm.nebular.mdm.kms.api;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalTime;
import java.util.List;

/**
 * @author zxw
 * @date 2021-02-19 13:52
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class KmsGrabRuleVo extends KmsBaseVo{

    @ApiModelProperty("客户帐号")
    private String loginAcc;

    @ApiModelProperty("客户密码")
    private String loginPass;

    @ApiModelProperty("状态")
    private String comomStatus;

    @ApiModelProperty("规则名称")
    private String name;

    private String accountId;

    @ApiModelProperty("运营管理后台直营体系id")
    private String bsDirectId;

    @ApiModelProperty("运营管理后台单据类型id")
    private String bsInvoiceId;

    @ApiModelProperty("直营体系名称")
    private String directSystemName;

    @ApiModelProperty("直营体系id")
    private String directSystemId;

    @ApiModelProperty("单据类型名称")
    private String invoiceName;

    @ApiModelProperty("单据类型id")
    private String invoiceId;

    @ApiModelProperty("开始时间")
    private LocalTime startDate;

    @ApiModelProperty("结束时间")
    private LocalTime endDate;

    @ApiModelProperty("是否客户所有门店")
    private boolean kmsAllStore;

    @ApiModelProperty("选择门店id集合")
    private List<String> stores;

    @ApiModelProperty("规则参数")
    private Object params;

    @ApiModelProperty("间隔时间")
    private String requency;
}
