package com.biz.crm.nebular.mdm.login;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 小程序绑定微信并登录请求参数
 *
 * @author Tao.Chen
 * @date 2021-02-19 11:47:07
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmAppletWeChatBindLoginReqVo", description = "小程序绑定微信并登录请求参数")
public class MdmAppletWeChatBindLoginReqVo {

    @ApiModelProperty("用户登录名")
    private String userName;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("微信唯一标识")
    private String openId;

    @ApiModelProperty("微信头像")
    private String headImgUrl;

    @ApiModelProperty("微信昵称")
    private String nickName;

}