package com.biz.crm.nebular.sfa.worksign.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * @author ren.gang
 * @ClassName SfaLeaveCancelInfoRespVo.java
 * @Description 请假销假详情返回Vo
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "请假销假详情返回Vo")
@SaturnEntity(name = "SfaLeaveCancelInfoRespVo", description = "请假销假详情返回Vo")
public class SfaLeaveCancelInfoRespVo {

    /**
     * 销假信息
     */

    @ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("请假id")
    private String leaveId;

    @ApiModelProperty("销假申请日期(yyyy-MM-dd HH:mm:dd)")
    private String cancelApplicationDate;

    @ApiModelProperty("销假开始时间")
    private String cancelBeginTime;

    @ApiModelProperty("销假结束时间")
    private String cancelEndTime;

    @ApiModelProperty("销假天数")
    private String cancelDays;

    @ApiModelProperty("销假日期明细")
    private String cancelTimeInfoListJson;

    @ApiModelProperty("销假审核任务id")
    private String auditTaskId;

    @ApiModelProperty("销假审批状态")
    private String bpmStatus;

    @ApiModelProperty("销假审批状态名称")
    private String bpmStatusName;

    @ApiModelProperty("销假审批通过时间")
    private String passStatusDate;

    /**
     * 请假信息
     */
    @ApiModelProperty("请假类型")
    private String leaveType;

    @ApiModelProperty("请假类型名称")
    private String leaveTypeName;

    @ApiModelProperty("请假事由")
    private String leaveReason;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织名称")
    private String orgName;

    @ApiModelProperty("申请日期(yyyy-MM-dd HH:mm:dd)")
    private String applicationDate;

    @ApiModelProperty("开始时间(yyyy-MM-dd HH)")
    private String beginTime;

    @ApiModelProperty("结束时间(yyyy-MM-dd HH)")
    private String endTime;

    @ApiModelProperty("日期明细json")
    private String timeInfoListJson;

    @ApiModelProperty("请假时长(天)")
    private String leaveDuration;

    @ApiModelProperty("附件列表json")
    private String attachmentListJson;

}
