package com.biz.crm.nebular.activiti.listener.req;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @CLASS_DESCRIBE: 流程监听配置表 请求vo
 * @AUTHOR: create by zkey on 2020-11-02
 */
@Data
@Builder
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActivitiListenerReqVo", description = "流程监听vo")
@AllArgsConstructor
@NoArgsConstructor
@CrmColumnResolve
public class ActivitiListenerReqVo extends PageVo {
    private List<String> ids;

    @ApiModelProperty("监听名称")
    private String listenerName;//监听名称

    @ApiModelProperty("监听类路径")
    private String className;//监听类路径

    @ApiModelProperty("监听类型")
    private String listenerType;//监听类型

    @ApiModelProperty("事件类型")
    private String event;//事件类型

    @ApiModelProperty("表达式")
    private String expression;//表达式

    @ApiModelProperty("数据状态")
    private String enableStatus;//数据状态
}
