package com.biz.crm.nebular.dms.notice;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 公司资料主表
 * @Author: zhangyuzhu
 * @Date: 2020/9/10 14:46
 **/
//@Entity
//@Table(name = "dms_notice_area")
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "公告范围的vo")
@SaturnEntity(name = "NoticeAreaVo", description = "公告范围")
@SaturnDomain(value = "noticearea")
public class NoticeAreaVo extends CrmExtVo {


    @ApiModelProperty(value = "公告id")
    @SaturnColumn(description = "公告id")
    private String noticeId;

    @ApiModelProperty(value = "组织code")
    @SaturnColumn(description = "组织code")
    private String orgCode;

    @ApiModelProperty(value = "组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty(value = "客户code")
    @SaturnColumn(description = "客户code")
    private String cusCode;

    @ApiModelProperty(value = "客户名称")
    @SaturnColumn(description = "客户名称")
    private String cusName;

    @ApiModelProperty(value = "是否包含")
    @SaturnColumn(description = "是否包含")
    private Integer containFlag;
}
