package com.biz.crm.nebular.mdm.role.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 角色下拉框请求VO
 *
 * @author Tao.Chen
 * @date 2020-12-02 11:01:25
 */
@Data
@ApiModel(value = "MdmRoleSelectReqVo", description = "角色下拉框请求VO")
@Accessors(chain = true)
public class MdmRoleSelectReqVo {

    @ApiModelProperty("返回条数，不传返回默认数量")
    private Integer pageSize;

    @ApiModelProperty("启用状态，精确查询")
    private String enableStatus;

    @ApiModelProperty("角色编码，模糊查询")
    private String roleCode;

    @ApiModelProperty("角色名称，模糊查询")
    private String roleName;

    @ApiModelProperty("角色编码或名称模糊查询")
    private String roleCodeOrName;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodeList;
}
