package com.biz.crm.nebular.fee.pool.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 货补费用池商品组查询请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolGoodsProductGroupReqVo", description = "货补费用池商品组查询请求VO")
public class FeePoolGoodsProductGroupReqVo extends PageVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("客户编码（必传）")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("查询价格类型（为空则不查询价格）")
    private String conditionType;

    @ApiModelProperty("货补产品层级编码")
    private String goodsProductLevelCode;

    @ApiModelProperty("货补产品层级名称")
    private String goodsProductLevelName;

    @ApiModelProperty("货补商品编码")
    private String goodsProductCode;

    @ApiModelProperty("货补商品名称")
    private String goodsProductName;

}