package com.biz.crm.nebular.mdm.user.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 客户用户信息列表返回VO
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户用户信息列表返回VO")
@CrmColumnResolve
public class MdmCustomerUserPageRespVo extends CrmExtTenVo {

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("用户类型")
    @CrmDict(typeCode = DictConstant.USER_TYPE,dictCodeField = "userType")
    private String userTypeName;

    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @Deprecated
    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

    @ApiModelProperty("生效时间 yyyy-MM-dd HH:mm:ss")
    private String endTime;

    @ApiModelProperty("失效时间 yyyy-MM-dd HH:mm:ss")
    private String startTime;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("锁定状态 003/009")
    private String lockState;

    @ApiModelProperty("锁定状态")
    @CrmDict(typeCode = DictConstant.LOCK_STATE, dictCodeField = "lockState")
    private String lockStateName;

    @ApiModelProperty("最后一次登录时间")
    private String lastLoginTime;

    @ApiModelProperty("关联客户编码")
    private String customerCode;

    @ApiModelProperty("关联客户")
    private String customerName;

    @ApiModelProperty("用户头像url")
    private String userHeadUrl;

    @ApiModelProperty("客户用户冗余客户编码集合、英文逗号间隔")
    @Deprecated
    private String customerCodeRedundancy;

    @ApiModelProperty("客户用户冗余客户名称集合、英文逗号间隔")
    @Deprecated
    private String customerNameRedundancy;

    @ApiModelProperty("企业用户冗余关联的职位编码集合（英文逗号间隔）")
    @Deprecated
    private String positionCodeRedundancy;

    @ApiModelProperty("企业用户冗余关联的职位名称集合（英文逗号间隔）")
    @Deprecated
    private String positionNameRedundancy;

}