package com.biz.crm.nebular.activiti.act.req;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author weston
 * @date 2020-12-23
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "TaskCommunicateReqVO", description = "发起沟通请求VO")
@AllArgsConstructor
@NoArgsConstructor
@CrmColumnResolve
public class TaskCommunicateReqVO {

    @ApiModelProperty(value = "节点ID", required = true)
    private String taskId;

    @ApiModelProperty(value = "来源用户", required = true)
    private String fromUserCode;

    @ApiModelProperty(value = "来源用户岗位", required = true)
    private String fromUserPosCode;

    @ApiModelProperty(value = "沟通内容", required = true)
    private String content;

    @ApiModelProperty(value = "沟通目标用户", required = true)
    private List<CopyToUserReqVO> users;
}
