package com.biz.crm.nebular.sfa.worksign.req;

import com.bizunited.platform.common.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author ren.gang
 * @ClassName SfaLeaveCancelReqVo.java
 * @Description 销假请求对象
 * @createTime 2020年12月09日 22:38:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaLeaveCancelReqVo", description = "销假请求 ")
public class SfaLeaveCancelReqVo extends UuidVo {

    @ApiModelProperty(value = "请假id", required = true)
    private String leaveId;

    @ApiModelProperty("开始时间")
    private String beginTime;

    @ApiModelProperty("结束时间")
    private String endTime;

    @ApiModelProperty(value = "日期明细列表", required = true)
    private List<SfaApplyTimeInfoReqVo> timeInfoList;

    @ApiModelProperty("销假天数")
    private String cancelDays;

    public SfaLeaveCancelReqVo(){}
    public SfaLeaveCancelReqVo(String leaveId) {
        this.leaveId = leaveId;
    }
    public SfaLeaveCancelReqVo(String leaveId, String beginTime, String endTime, String cancelDays, List<SfaApplyTimeInfoReqVo> timeInfoList) {
        this.leaveId = leaveId;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.cancelDays = cancelDays;
        this.timeInfoList = timeInfoList;
    }

    /**
     * 查询专用
     */
    @ApiModelProperty(value = "请假id集合", required = true)
    private List<String> leaveIdList;

    @ApiModelProperty("开始时间-开始")
    private String beginTimeStart;

    @ApiModelProperty("开始时间-结束")
    private String beginTimeEnd;

    @ApiModelProperty("结束时间-开始")
    private String endTimeStart;

    @ApiModelProperty("结束时间-结束")
    private String endTimeEnd;



}
