package com.biz.crm.nebular.activiti.task.resp;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

/**
 * @author weston
 * @date 2020-12-21
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "查询流程表单参数响应vo")
@Builder(toBuilder = true)
@AllArgsConstructor
@NoArgsConstructor
@CrmColumnResolve
public class FormParamQueryRspVO {

    @ApiModelProperty(value = "是否可编辑状态")
    private boolean status;
    @ApiModelProperty(value = "业务表单ID")
    private String id;
    @ApiModelProperty(value = "业务表单连接参数")
    private String urlParam;
    @ApiModelProperty(value = "业务表单权限")
    private String formRole;
}
