package com.biz.crm.nebular.dms.productdiscount.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 产品折扣审核调整返回vo
 *
 * @author lf
 * @date 2020-12-23 15:30:57
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "产品折扣审核调整")
@SaturnEntity(name = "DmsProductDiscountAdjustmentReviewRespVo", description = "产品折扣审核调整")
public class DmsProductDiscountAdjustmentReviewRespVo extends CrmExtTenVo {
    @ApiModelProperty("现金折扣ID")
    @SaturnColumn(description = "现金折扣ID")
    private String productDiscountPoolId;

    @ApiModelProperty("流水号")
    @SaturnColumn(description = "流水号")
    private String code;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("销售公司编码")
    @SaturnColumn(description = "销售公司编码")
    private String companyCode;

    @ApiModelProperty("销售公司名称")
    @SaturnColumn(description = "销售公司名称")
    private String companyName;

    @ApiModelProperty("类型")
    @SaturnColumn(description = "类型")
    private String type;

    @ApiModelProperty("状态")
    @SaturnColumn(description = "状态")
    private String status;

    @ApiModelProperty("商品编码")
    @SaturnColumn(description = "商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    @SaturnColumn(description = "商品名称")
    private String productName;

    @ApiModelProperty("基础单位")
    @SaturnColumn(description = "基础单位")
    private String baseUnit;

    @ApiModelProperty("数量")
    @SaturnColumn(description = "数量")
    private String num;

    @ApiModelProperty("单价金额")
    @SaturnColumn(description = "单价金额")
    private BigDecimal unitPrice;

    @ApiModelProperty("金额")
    @SaturnColumn(description = "金额")
    private BigDecimal amount;

    @ApiModelProperty("审批时间")
    @SaturnColumn(description = "审批时间")
    private String approvalTime;

    @ApiModelProperty("审批人账号")
    @SaturnColumn(description = "审批人账号")
    private String approvalUserName;

    @ApiModelProperty("审批人姓名")
    @SaturnColumn(description = "审批人姓名")
    private String approvalRealName;

    @ApiModelProperty("审批人组织编码")
    @SaturnColumn(description = "审批人组织编码")
    private String approvalOrgCode;

    @ApiModelProperty("审批人组织名称")
    @SaturnColumn(description = "审批人组织名称")
    private String approvalOrgName;

    @ApiModelProperty("审批人职位编码")
    @SaturnColumn(description = "审批人职位编码")
    private String approvalPosCode;

    @ApiModelProperty("审批人职位名称")
    @SaturnColumn(description = "审批人职位名称")
    private String approvalPosName;

}