package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * 组织-终端关联列表入参
 *
 * @author zxw
 * @date 2020-10-09 15:49
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmOrgTerminalReqVo", description = "组织-终端关联列表入参")
public class MdmOrgTerminalPageReqVo extends PageVo {

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("组织编码")
    @NotBlank(message = "组织编码不能为空")
    private String orgCode;
}
