package com.biz.crm.nebular.sfa.worksign.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 考勤历史列表返回Vo
 *
 * @author fily
 * @date 2020-11-24 17:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "考勤历史列表返回Vo")
@SaturnEntity(name = "SfaSignHistoryListRespVo", description = "考勤历史列表返回Vo ")
public class SfaSignHistoryListRespVo {

    @ApiModelProperty("考勤记录id")
    private String id;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("考勤规则明细表id 考勤规则明细表id")
    @SaturnColumn(description = "考勤规则明细表id 考勤规则明细表id")
    private String wsRuleInfoId;

    @ApiModelProperty("打卡类型 CLOCK_IN : 上班签到; CLOCK_OUT : 下班签退;")
    @SaturnColumn(description = "打卡类型 打卡类型（1:上班签到;2:下班签退）")
    private String workSignType;

    @ApiModelProperty("打卡类型描述 打卡类型描述")
    @SaturnColumn(description = "打卡类型描述 打卡类型描述")
    private String workSignDesc;

    @ApiModelProperty("考勤时间 考勤时间(HH:mm:ss)")
    @SaturnColumn(description = "考勤时间 考勤时间(HH:mm:ss)")
    private String workSignTime;

    @ApiModelProperty("考勤日期")
    @SaturnColumn(description = "考勤日期")
    private String ruleDate;

    @ApiModelProperty("考勤地点 考勤地点")
    @SaturnColumn(description = "考勤地点 考勤地点")
    private String workSignPlace;

    @ApiModelProperty("考勤状态 NONE:未打卡;OK:正常;BE_LATE:迟到;LEAVE_EARLY:早退;")
    @SaturnColumn(description = "考勤状态 NONE:未打卡;OK:正常;BE_LATE:迟到;LEAVE_EARLY:早退;")
    private String workSignStatus;

    @ApiModelProperty("考勤状态描述")
    @SaturnColumn(description = "考勤状态描述")
    private String workSignStatusDesc;

    @ApiModelProperty("照片路径(物理路径)")
    @SaturnColumn(description = "照片路径(物理路径)")
    private String picPath;

    @ApiModelProperty("照片地址")
    @SaturnColumn(description = "照片地址")
    private String picUrl;

    @ApiModelProperty("打卡人员名称 打卡人员名称")
    @SaturnColumn(description = "打卡人员名称 打卡人员名称")
    private String wsRealName;

    @ApiModelProperty("打卡职位编码 打卡职位编码")
    @SaturnColumn(description = "打卡职位编码 打卡职位编码")
    private String wsPosCode;

    @ApiModelProperty("打卡职位名称 打卡职位名称")
    @SaturnColumn(description = "打卡职位名称 打卡职位名称")
    private String wsPosName;

    @ApiModelProperty("打卡组织编码 打卡组织编码")
    @SaturnColumn(description = "打卡组织编码 打卡组织编码")
    private String wsOrgCode;

    @ApiModelProperty("打卡组织名称 打卡组织名称")
    @SaturnColumn(description = "打卡组织名称 打卡组织名称")
    private String wsOrgName;

}
