package com.biz.crm.nebular.mdm.role.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * 用户关联客户分页查询
 *
 * @author zxw
 * @date 2020-10-10 10:22
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmRoleRelationPositionPageReqVo", description = "角色关联职位分页查询请求")
public class MdmRoleRelationPositionPageReqVo extends PageVo {

    @ApiModelProperty("查询类型(1:未关联任何角色的职位，2:未关联当前角色的职位,3:已关联当前角色的职位)")
    private String queryType;

    @ApiModelProperty("角色编码")
    private String roleCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("用户名")
    private String fullName;
}
