package com.biz.crm.nebular.mdm.coderule.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 编码规则请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-05 10:47:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmCodeRuleReqVo", description = "编码规则")
public class MdmCodeRuleReqVo extends PageVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("业务key")
    private String ruleCode;

    @ApiModelProperty("前缀")
    private String prefix;

    @ApiModelProperty("时间戳格式")
    private String dateFormat;

    @ApiModelProperty("编码总长度")
    private Integer codeLength;

    @ApiModelProperty("规则描述")
    private String ruleDescription;

    @ApiModelProperty("起始值")
    private Integer initialValue;

    @ApiModelProperty("当前值")
    private Integer currentValue;

    @ApiModelProperty("生成时间")
    private String generateDate;

    @ApiModelProperty("所属模块")
    private String ruleModule;

}