package com.biz.crm.nebular.fee.pool.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 费用池操作记录表返回vo
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用池操作记录表")
@CrmColumnResolve
public class FeePoolOperationRespVo extends CrmBaseVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("操作记录编号")
    private String operationCode;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("来源编号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("支付方式")
    private String payType;

    @ApiModelProperty("操作时间 yyyy-MM-dd HH:mm:ss")
    private String operationDateTime;

    @ApiModelProperty("操作金额（元）（含正负）")
    private BigDecimal operationAmount;

    @ApiModelProperty("附件")
    private List<FeePoolFileRespVo> fileList;


    @ApiModelProperty("费用池类型")
    private String poolType;

    @ApiModelProperty("费用池类型")
    @CrmDict(typeCode = DictConstant.FEE_POOL_TYPE, dictCodeField = "poolType")
    private String poolTypeName;

    @ApiModelProperty("审批状态")
    private String bpmStatus;

    @ApiModelProperty("支付方式")
    @CrmDict(typeCode = DictConstant.FEE_POOL_PAY_TYPE, dictCodeField = "payType")
    private String payTypeName;

    @ApiModelProperty("操作类型")
    @CrmDict(typeCode = DictConstant.FEE_POOL_OPERATION_TYPE, dictCodeField = "operationType")
    private String operationTypeName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("渠道类型")
    private String channelType;

    @ApiModelProperty("组织编码(可能是集合，英文逗号间隔)")
    private String orgCode;

    @ApiModelProperty("组织名称(可能是集合，英文逗号间隔)")
    private String orgName;

    @ApiModelProperty("折扣类型")
    private String discountType;

    @ApiModelProperty("折扣类型")
    @CrmDict(typeCode = DictConstant.FEE_POOL_DISCOUNT_TYPE, dictCodeField = "discountType")
    private String discountTypeName;

    @ApiModelProperty("货补产品层级编码")
    private String goodsProductLevelCode;

    @ApiModelProperty("货补产品层级名称")
    private String goodsProductLevelName;

    @ApiModelProperty("货补商品编码(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductCode;

    @ApiModelProperty("货补商品名称(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductName;

}