package com.biz.crm.nebular.sfa.worksign.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author ren.gang
 * @ClassName SfaAuditListLeaveCancelReqVo.java
 * @Description 销假审核列表查询请求vo
 * @createTime 2021年01月13日 17:50:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaAuditListLeaveCancelReqVo", description = "销假审核列表查询请求vo")
public class SfaAuditListLeaveCancelReqVo extends PageVo {

    @ApiModelProperty("姓名")
    private String realName;

    @ApiModelProperty("申请时间-开始")
    private String applicationDateStart;

    @ApiModelProperty("申请时间-结束")
    private String applicationDateEnd;

    @ApiModelProperty("开始时间-开始")
    private String beginTimeStart;

    @ApiModelProperty("开始时间-结束")
    private String beginTimeEnd;

    @ApiModelProperty("结束时间-开始")
    private String endTimeStart;

    @ApiModelProperty("结束时间-结束")
    private String endTimeEnd;

    @ApiModelProperty("考勤审核类型(1待审核，2已审批)")
    private String auditType;

    @ApiModelProperty("审核任务id集合")
    List<String> auditTaskIdList;

}
