package com.biz.crm.nebular.mdm.pricesetting.resp;

import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 条件字段类型主表 返回vo
 *
 * @author huanglong
 * @date 2020-10-20 10:57:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "条件字段类型主表 ")
@CrmColumnResolve
public class MdmPriceConditionTypeRespVo extends CrmExtVo {

    @ApiModelProperty("条件字段类型编码")
    private String conditionTypeCode;

    @ApiModelProperty("条件字段类型描述")
    private String conditionTypeDesc;

    @ApiModelProperty("抬头/行项目)")
    private String conditionTypeType;

    @ApiModelProperty("条件字段分类类型名称(head:抬头/line:行项目)")
    @CrmDict(typeCode = TpmGlobalDictConstants.CONDITION_TYPE_TYPE, dictCodeField = "conditionTypeType")
    private String conditionTypeTypeName;

    @ApiModelProperty("条件类型分类关联集合")
    private List<MdmPriceConditionTypeRelGroupRespVo> conditionTypeRelGroupReqVoList;
}