package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 基本查询请求
 *
 * @author zxw
 * @date 2020-10-16 11:24
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EngineOrgSearchReqVo", description = "基本查询请求")
public class MdmBaseOrgSearchReqVo extends PageVo {

    @ApiModelProperty("用户帐号")
    private String userAccount;

    @ApiModelProperty("组织编码集合:查询当前及下级")
    private List<String> orgCodeList;

    @ApiModelProperty("启用状态")
    private String enableStatus;

    public static void setUpVo(MdmBaseOrgSearchReqVo upVo) {
        Integer pageNum = upVo.getPageNum();
        Integer pageSize = upVo.getPageSize();
        upVo.setPageNum(1);
        upVo.setPageSize(5000);
    }

}
