package com.biz.crm.nebular.dms.salesarea;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author liufan E-mail:fan.liu@biz-united.com.cn
 * @version 创建时间：2021/2/20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "销售区域vo")
public class SalesAreaVo extends CrmExtTenVo {
    /**
     * 合同编码
     */
    @ApiModelProperty("合同编码")
    private String saleContractCode;
    /**
     * 省份
     */
    @ApiModelProperty("省份")
    private String province;
    /**
     * 城市
     */
    @ApiModelProperty("城市")
    private String city;
    /**
     * 区/县
     */
    @ApiModelProperty("区/县")
    private String district;
    /**
     * 乡镇
     */
    @ApiModelProperty("乡镇")
    private String village;
    /**
     * 街道
     */
    @ApiModelProperty("街道")
    private String street;
    /**
     * list
     */
    @ApiModelProperty("list")
    private List<SalesAreaVo> voList;
}
