package com.biz.crm.nebular.mdm.customer;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Set;

/**
 * @author zxw
 */
@ApiModel("替换关联当前客户终端入参")
@Data
@Accessors(chain = true)
public class MdmCustomerCorrelatedTerminalReplaceReqVo {

    @ApiModelProperty("原当前客户编码")
    @NotBlank(message = "原客户编码不能为空")
    private String oldCustomerCode;

    @ApiModelProperty("新客户编码")
    @NotBlank(message = "新客户编码不能为空")
    private String newCustomerCode;

    @ApiModelProperty("终端编码集合")
    @NotEmpty(message = "终端集合不能为空")
    private Set<String> terminalCodeList;
}
