package com.biz.crm.nebular.mdm.notice.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 公告管理 请求vo
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:42
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaNoticeReqVo", description = "公告管理 ")
public class MdmNoticeReqVo extends CrmBaseVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("公告编码 公告编码")
    private String noticeCode;

    @ApiModelProperty("公告标题 公告标题")
    private String noticeTitle;

    @ApiModelProperty("公告类型 公告类型")
    private String noticeType;

    @ApiModelProperty("公告名称 公告名称")
    private String noticeOrg;

    @ApiModelProperty("有效开始时间 有效开始时间")
    private String beginDate;

    @ApiModelProperty("有效结束时间 有效结束时间")
    private String endDate;

    @ApiModelProperty("公告内容 公告内容")
    private String noticeContent;

    @ApiModelProperty("公告管理-公告发布范围")
    private List<MdmNoticeReceivingReqVo> noticeReceivingReqVos;
    @ApiModelProperty("公告管理-公告附件")
    private List<MdmNoticeFileReqVo> noticeFileReqVos;
    @ApiModelProperty("公告编码集合 公告编码集合")
    private List<String> noticeCodes;

    @ApiModelProperty("组织编码集合")
    private List<String> orgCodeList;

    @ApiModelProperty("公告发布状态")
    private String noticeReleaseStatus;

    @ApiModelProperty("公告置顶状态 是 否")
    private String noticeTopState;

    @ApiModelProperty("公告评论状态 0不可评论 可评论")
    private String commentState;
}