package com.biz.crm.nebular.sfa.calculateSalary.resp;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 计算薪资日期返回vo
 *
 * @author lf
 * @date 2020-12-28 15:00:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "计算薪资日期")
@SaturnEntity(name = "SfaCalculateSalaryDateRespVo", description = "计算薪资日期")
public class SfaCalculateSalaryDateRespVo extends CrmExtTenVo {
    @ApiModelProperty("年份")
    @SaturnColumn(description = "年份")
    private String year;

    @ApiModelProperty("日期")
    @SaturnColumn(description = "日期")
    private String day;

    @ApiModelProperty("是否计算薪资")
    @SaturnColumn(description = "是否计算薪资")
    private String isCalculationSalary;

    @ApiModelProperty("是否计算薪资")
    private String isCalculationSalaryDesc;

    @ApiModelProperty("节假日名称")
    @SaturnColumn(description = "节假日名称")
    private String salary;

    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("真实姓名")
    @SaturnColumn(description = "真实姓名")
    private String realName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

}