package com.biz.crm.nebular.tpm.audit.resp;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 核销申请明细表 返回vo
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "核销申请明细表 ")
@CrmColumnResolve
@SaturnEntity(name = "TpmAuditDetailRespVo", description = "核销申请明细表 ")
public class TpmAuditDetailRespVo extends CrmExtVo {
    @ApiModelProperty("核销申请编码")
    @SaturnColumn(description = "核销申请编码")
    private String auditCode;

    @ApiModelProperty("核销申请明细编码")
    @SaturnColumn(description = "核销申请明细编码")
    private String auditDetailCode;

    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    @SaturnColumn(description = "活动名称")
    private String actName;

    @ApiModelProperty("活动明细编码")
    @SaturnColumn(description = "活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动大类编码")
    @SaturnColumn(description = "活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("活动大类名称")
    @SaturnColumn(description = "活动大类名称")
    private String categoriesName;

    @ApiModelProperty("活动细类编码")
    @SaturnColumn(description = "活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    @SaturnColumn(description = "活动细类名称")
    private String fineName;

    @ApiModelProperty("企业组织编码")
    @SaturnColumn(description = "企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    @SaturnColumn(description = "企业组织名称")
    private String orgName;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("门店编码")
    @SaturnColumn(description = "门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @SaturnColumn(description = "门店名称")
    private String terminalName;

    @ApiModelProperty("费用申请金额")
    @SaturnColumn(description = "费用申请金额")
    private BigDecimal actDetailApplyAmount;

    @ApiModelProperty("支付方式(字典编码)")
    @SaturnColumn(description = "支付方式(字典编码)")
    private String payType;

    @ApiModelProperty("支付方式名称")
    @SaturnColumn(description = "支付方式名称")
    private String payTypeName;

    @ApiModelProperty("支付方式类型(字典编码)")
    @SaturnColumn(description = "支付方式类型(字典编码)")
    private String payTypeType;

    @ApiModelProperty("支付方式(集合的json,字典)")
    @SaturnColumn(description = "支付方式")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<DictItemVo> payTypes;

    @ApiModelProperty("支付方式集合的json字符串")
    @SaturnColumn(description = "支付方式集合的json字符串")
    private String payTypesJsonStr;

    @ApiModelProperty("已核销金额")
    @SaturnColumn(description = "已核销金额")
    private BigDecimal alreadyAuditAmount;

    @ApiModelProperty("是否完全核销")
    @SaturnColumn(description = "是否完全核销")
    private String isAllAudit;

    @ApiModelProperty("本次核销金额")
    @SaturnColumn(description = "本次核销金额")
    private BigDecimal auditApplyAmount;

    @ApiModelProperty("已上账金额")
    @SaturnColumn(description = "已上账金额")
    private BigDecimal feeUsed;

    @ApiModelProperty("是否完全上账(Y/N)")
    @SaturnColumn(description = "是否完全上账(Y/N)")
    private String isAllFeeUsed;

    @ApiModelProperty("临时字段唯一值")
    @SaturnColumn(description = "临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("可上帐金额")
    @SaturnColumn(description = "可上帐金额")
    private BigDecimal feeAccessible;

    @ApiModelProperty("预算科目编码")
    @SaturnColumn(description = "预算科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("预算科目名称")
    @SaturnColumn(description = "预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("是否允许多次核销(Y/N)")
    private String isAllowRepeatAudit;
}