package com.biz.crm.common;

/**
 * @Project crm
 * @PackageName com.biz.crm.common
 * @ClassName TpmGlobalDictConstants
 * @Author HuangLong
 * @Date 2020/8/31 15:13
 * @Description 字典key常量
 */
public interface TpmGlobalDictConstants {

    /**
     * 上下架状态
     */
    String IS_SHELF="is_shelf";
    /**
     * 删除状态
     */
    String DEL_FLAG ="del_flag";
    /**
     * 启用禁用状态
     */
    String ENABLE_STATUS ="enable_status";

    /**
     * 预算财年-年度
     */
    String FISCAL_YEAR="fiscal_year";
    /**
     * 预算财年-季度
     */
    String FISCAL_QUATER="fiscal_quater";
    /**
     * 预算财年-月度
     */
    String FISCAL_MONTH="fiscal_month";
    /**
     * 预算财年-半年度
     */
    String FISCAL_HALF_YEAR="fiscal_half_year";

    /**
     * 预算科目类型
     */
    String SUBJECTS_TYPE="subjects_type";

    /**
     * 预算科目分组
     */
    String SUBJECTS_GROUP="subjects_group";

    /**
     * 预算科目是否滚动
     */
    String IS_ROLL="is_roll";

    /**
     * 预算科目  是否为活动预算
     */
    String IS_ACT_BUDGET ="is_act_budget";
    /**
     * 预算科目控制类型
     */
    String CONTROL_TYPE="control_type";

    /**
     * 核销采集示例类型
     */
    String EXAMPLE_TYPE="example_type";
    /**
     * 财务费用归类
     */
    String FINANCIAL_FEE_TYPE="financial_fee_type";

    /**
     * 业务费用归类
     */
    String BUSINESS_FEE_TYPE="business_fee_type";
    /**
     * 适用活动类型
     */
    String ACTIVITY_CATEGORIES_TYPE="activity_categories_type";
    /**
     * 活动大类范围类型-组织
     */
    Integer RANGE_ORG=1;
    /**
     * 活动大类范围类型-组织类型
     */
    Integer RANGE_ORG_TYPE=2;
    /**
     * 包含
     */
    String CONTAIN="Y";
    /**
     * 非包含
     */
    String NON_CONTAIN="N";
    /**
     * 活动发布需求  部门/客户/终端
     */
    String ACTIVITY_RELEASE_NEED="activity_release_need";
    /**
     * 活动方式 后返费用/代垫费用/随单费用
     */
    String ACTIVITY_TYPE="activity_type";
    /**
     * 支付方式 现金/转预付款/账扣/货补/折扣/随单/票折
     */
    String PAY_TYPE="pay_type_d";

    /**
     * 支付方式类型
     */
    String PAY_TYPE_TYPE="pay_type_type";

    /**
     * 渠道
     */
    String CHANNEL="channel";

    /**
     * 费用预算类型
     */
    String FEE_BUDGET_TYPE="fee_budget_type";

    /**
     * 收入预算分组
     */
    String INCOME_GROUP = "income_group";

    /**
     * 财务科目类型
     */
    String FINANCE_SUBJECT_TYPE = "finance_subject_type";
    /**
     * 费用预算明细类型
     */
    String FEE_BUDGET_DETAIL_TYPE = "fee_budget_detail_type";

    /**
     * 活动类型(项目活动,领用活动)
     */
    String ACT_TYPE = "act_type";

    /**
     * 活动审批状态
     */
    String ACT_APPROVE_STATUS = "act_approve_status";

    /**
     * 活动获取费用预算的时间区间配置(当前时间区间,当前时间区间以及未来区间)
     */
    String BUDGET_USE_DATE_RULE="budget_use_date_rule";

    /**
     * 条件字段类型类型
     */
    String CONDITION_TYPE_TYPE="condition_type_type";

    /**
     * 活动申请表单-数据字典类型
     */
    String EVENT_APPLICATION_FORM="act_detail_prefix";


    /**
     * 活动采集字段表-输入类型
     */
    String INPUT_TYPE = "act_field_collect_fill_type";

    /**
     * 活动采集字段表-时间格式
     */
    String TIME_FORMAT = "act_field_collect_date_format";

    /**
     * 费用上账状态字典
     */
    String ACCOUNT_STATUS = "account_status";

    /**
     * 费用预算-年度
     */
    String BUDGET_YEAR="budget_year";
    /**
     * 费用预算-季度
     */
    String BUDGET_QUATER="budget_quater";
    /**
     * 费用预算-月度
     */
    String BUDGET_MONTH="budget_mouth";
    /**
     * 收入预算类型
     */
    String INCOME_TYPE = "income_type";

    /**
     * 负责人
     */
    String SYS_TASK = "sys_task";
    /**
     * 发布版本
     */
    String RELEASE_VERSION= "release_version";

    /**
     * bug 所属模块
     */
    String BUG_OWNING_MODULE = "bug_owning_module";
}
