package com.biz.crm.nebular.tpm.act.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.tpm.act.req
 * @ClassName ActGetCategoriesByBudgetReqVo
 * @Author HuangLong
 * @Date 2020/10/15 13:45
 * @Description 活动新增根据选定的费用预算维度查询活动大类,请求vo
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmActReqVo", description = "活动信息主表;")
public class ActGetCategoriesByBudgetReqVo extends CrmExtVo {

    @ApiModelProperty("控制维度的ID集合")
    private List<String> controlIds;

    @ApiModelProperty("活动大类编码或者名称")
    private String categoriesCodeOrName;

    @ApiModelProperty("活动类型(字典)")
    private String actType;

    @ApiModelProperty("范围编码集合")
    private List<String> rangeCodes;

    @ApiModelProperty("不包含的编码集合(弹窗使用)")
    private List<String> notInCodeList;

}
