package com.biz.crm.nebular.mdm.customer;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 客户开票信息返回vo
 *
 * @author zxw
 * @date 2021-01-24 22:48:12
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户开票信息")
@SaturnEntity(name = "MdmCustomerBillRespVo", description = "客户开票信息")
public class MdmCustomerBillRespVo extends CrmExtTenVo {
    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("开票单位")
    @SaturnColumn(description = "开票单位")
    private String billCompany;

    @ApiModelProperty("税号")
    @SaturnColumn(description = "税号")
    private String taxNumber;

    @ApiModelProperty("法人")
    @SaturnColumn(description = "法人")
    private String legal;

    @ApiModelProperty("开户银行")
    @SaturnColumn(description = "开户银行")
    private String depositBank;

    @ApiModelProperty("银行帐号")
    @SaturnColumn(description = "银行帐号")
    private String bankAccount;

    @ApiModelProperty("是否是默认开票信息，1是0否")
    @SaturnColumn(description = "是否是默认开票信息，1是0否")
    private String billMain;

}