package com.biz.crm.nebular.sfa.worksignrule.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 考勤规则-打卡时间;返回vo
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "考勤规则-打卡时间;")
@SaturnEntity(name = "SfaWorkSignTimeRespVo", description = "考勤规则-打卡时间;")
public class SfaWorkSignTimeRespVo extends CrmBaseVo {
    @ApiModelProperty("序号;序号")
    @SaturnColumn(description = "序号;序号")
    private String wstNo;

    @ApiModelProperty("上班打卡时间;上班时间")
    @SaturnColumn(description = "上班打卡时间;上班时间")
    private String gotoTime;

    @ApiModelProperty("下班打卡时间;下班时间")
    @SaturnColumn(description = "下班打卡时间;下班时间")
    private String gooffTime;

    @ApiModelProperty("上班打卡开始时间;打卡时间限制-可打上班卡开始时间")
    @SaturnColumn(description = "上班打卡开始时间;打卡时间限制-可打上班卡开始时间")
    private String gotoStartTime;

    @ApiModelProperty("上班打卡结束时间;打卡时间限制-可打上班卡结束时间")
    @SaturnColumn(description = "上班打卡结束时间;打卡时间限制-可打上班卡结束时间")
    private String gotoEndTime;

    @ApiModelProperty("下班打卡开始时间;打卡时间限制-可打下班卡开始时间")
    @SaturnColumn(description = "下班打卡开始时间;打卡时间限制-可打下班卡开始时间")
    private String gooffStartTime;

    @ApiModelProperty("下班打卡结束时间;打卡时间限制-可打下班卡结束时间")
    @SaturnColumn(description = "下班打卡结束时间;打卡时间限制-可打下班卡结束时间")
    private String gooffEndTime;

    @ApiModelProperty("考勤规则编码 考勤规则编码")
    @SaturnColumn(description = "考勤规则编码 考勤规则编码")
    private String ruleCode;

    @ApiModelProperty("考勤规则编码集合 考勤规则编码集合")
    @SaturnColumn(description = "考勤规则编码集合 考勤规则编码集合")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<String> ruleCodes;

    private String ext1 = StringUtils.EMPTY;

    private String ext2 = StringUtils.EMPTY;

    private String ext3 = StringUtils.EMPTY;

    private String ext4 = StringUtils.EMPTY;

    private String ext5 = StringUtils.EMPTY;

    private String ext6 = StringUtils.EMPTY;

    private String ext7 = StringUtils.EMPTY;

    private String ext8 = StringUtils.EMPTY;

    private String ext9 = StringUtils.EMPTY;

    private String ext10 = StringUtils.EMPTY;

}