package com.biz.crm.nebular.mdm.customer;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 客户信息：收货地址请求vo
 *
 * @author zxw
 * @date 2020-09-10 12:09:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmCustomerAddressConditionReqVo", description = "客户信息：收货地址：条件查询入参")
public class MdmCustomerAddressConditionReqVo {

    @ApiModelProperty("市")
    private String cityCode;

    @ApiModelProperty("区")
    private String districtCode;

    @ApiModelProperty("省")
    private String provinceCode;

    @ApiModelProperty("送达方编码")
    private String destinationCode;

    @ApiModelProperty("送达方名称")
    private String destinationName;

    @ApiModelProperty("详细地址")
    private String detailedAddress;

    @ApiModelProperty("联系人")
    private String contactName;

    @ApiModelProperty("联系电话")
    private String contactPhone;

    @ApiModelProperty("是否默认地址，1：是，0：否")
    private String defaultAddress;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("有效开始时间")
    private Boolean withinEffectiveTime;

}