package com.biz.crm.nebular.mdm.kms.api;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * @author zxw
 * @date 2021-02-28 22:54
 **/
@Data
public class KmsAcceptanceVoucherVo {

    /**
     * 企业验收单号
     */
    @ApiModelProperty(value="企业验收单号")
    private String orderNumber;

    /**
     * 商超验收单编号
     */
    @ApiModelProperty(value="商超验收单编号")
    private String kaOrderNumber;

    /**
     * 验收日期
     */
    @ApiModelProperty(value="验收日期")
    private String acceptanceDate;

    /**
     * 验收类型
     */
    @ApiModelProperty(value="验收类型")
    private String acceptanceType;

    /**
     * 企业门店/大仓编号
     */
    @ApiModelProperty(value="企业门店/大仓编号")
    private String storeCode;

    /**
     * 企业门店/大仓名称
     */
    @ApiModelProperty(value="企业门店/大仓名称")
    private String storeName;

    /**
     * 关联订货单
     */
    @ApiModelProperty(value="关联订货单")
    private String relateOrderNumber;

    /**
     * 商超门店/大仓编号
     */
    @ApiModelProperty(value="商超门店/大仓编号")
    private String kaStoreCode;

    /**
     * 商超门店/大仓名称
     */
    @ApiModelProperty(value="商超门店/大仓名称")
    private String kaStoreName;

    /**
     * 订货单总金额（含税）
     */
    @ApiModelProperty(value="订货单总金额（含税）")
    private String finalOrderAmount;

    /**
     * 验收单总金额（含税）
     */
    @ApiModelProperty(value="验收单总金额（含税）")
    private String finalAcceptanceAmount;

    /**
     * 单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)
     */
    @ApiModelProperty(value="单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)")
    private String invoicesSource;

    /**
     * 商超编号
     */
    @ApiModelProperty(value="商超编号")
    private String kaCode;

    /**
     * 创建时间
     */
    @ApiModelProperty(value="创建时间")
    private String orderCreateDate;

    /**
     * 修改时间
     */
    @ApiModelProperty(value="修改时间")
    private String orderUpdateDate;

    /**
     * 创建用户
     */
    @ApiModelProperty(value="创建用户")
    private String orderCreateName;

    /**
     * 更新用户
     */
    @ApiModelProperty(value="更新用户")
    private String orderUpdateName;

    /**
     * 验收数量
     */
    @ApiModelProperty(value="验收数量")
    private String acceptanceNumber;

    /**
     * 验收人
     */
    @ApiModelProperty(value="验收人")
    private String acceptanceUsername;

    /**
     * 验收人名称
     */
    @ApiModelProperty(value="验收人名称")
    private String acceptanceRealname;

    /**
     * 库存地编码
     */
    @ApiModelProperty(value="库存地编码")
    private String inventoryCode;

    /**
     * 库存地名称
     */
    @ApiModelProperty(value="库存地名称")
    private String inventoryName;

    /**
     * 验收金额（不含税）
     */
    @ApiModelProperty(value="验收金额（不含税）")
    private String acceptanceAmount;

    /**
     * 验收税金
     */
    @ApiModelProperty(value="验收税金")
    private String acceptanceTax;
}
