package com.biz.crm.nebular.mdm.user.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 终端用户信息返回列表VO
 * @author ql
 * @date 2021/2/3
 * @time 20:03
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmTerminalUserPageRespVo",description = "终端用户信息返回列表VO")
@CrmColumnResolve
public class MdmTerminalUserPageRespVo extends CrmExtTenVo {

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("用户类型展示")
    @CrmDict(typeCode = DictConstant.USER_TYPE,dictCodeField = "userType")
    private String userTypeName;

    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @Deprecated
    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

    @ApiModelProperty("生效时间 yyyy-MM-dd HH:mm:ss")
    private String endTime;

    @ApiModelProperty("失效时间 yyyy-MM-dd HH:mm:ss")
    private String startTime;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("锁定状态 003/009")
    private String lockState;

    @ApiModelProperty("锁定状态")
    @CrmDict(typeCode = DictConstant.LOCK_STATE, dictCodeField = "lockState")
    private String lockStateName;

    @ApiModelProperty("最后一次登录时间")
    private String lastLoginTime;

    @ApiModelProperty("关联终端编码")
    private String terminalCode;

    @ApiModelProperty("关联终端")
    private String terminalName;

    @ApiModelProperty("关联角色编码")
    private String roleCode;

    @ApiModelProperty("关联角色名称")
    private String roleName;

    @ApiModelProperty("用户头像url")
    private String userHeadUrl;

}
