package com.biz.crm.nebular.sfa.checkin.resp;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 签到组;返回vo
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "签到组;")
@SaturnEntity(name = "SfaCheckInGroupRespVo", description = "签到组;")
public class SfaCheckInGroupRespVo extends CrmExtTenVo {
    @ApiModelProperty("签到组名称")
    private String groupName;

    @ApiModelProperty("签到组编码")
    private String groupCode;

    @ApiModelProperty("打卡日期集合")
    private List<SfaCheckInDateRespVo> dateRespVos;

    @ApiModelProperty("打卡类型集合")
    private List<SfaCheckInTypeRespVo> typeRespVos;

    @ApiModelProperty("打卡类型名称集合")
    private String typeNames;

    @ApiModelProperty("打卡组织集合")
    private List<SfaCheckInOrgRespVo> orgRespVos;

    @ApiModelProperty("打卡人员集合")
    private List<SfaCheckInUserRespVo> userRespVos;

}