package com.biz.crm.nebular.tpm.account.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 根据支付方式类型和活动细类集合查询支付方式;请求vo
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmAccountUpdatePayTypeReqVo", description = "根据支付方式类型和活动细类集合查询支付方式入参;")
public class TpmPayTypeByTypeAndFineVo {

    @ApiModelProperty("支付方式类型")
    private String payTypeType;

    @ApiModelProperty("活动细类编码集合")
    private List<String> fineCodes;
}