package com.biz.crm.nebular.tpm.jiuact.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.act.resp.TmpActFeeShareRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActBudgetRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActFileRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 活动信息主表;返回vo
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类活动信息主表;")
public class TpmActJiuRespVo extends CrmExtVo {
    @ApiModelProperty("活动类型(字典)")
    private String actType;

    @ApiModelProperty("活动类型名称")
    private String actTypeName;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("是否跨组织")
    private String isCrossOrg;

    @ApiModelProperty("是否跨组织描述")
    private String isCrossOrgDesc;

    @ApiModelProperty("责任组织")
    private String orgCode;

    @ApiModelProperty("客户")
    private String customerCode;

    @ApiModelProperty("客户")
    private String customerName;

    @ApiModelProperty("组织名称")
    private String ogrName;

    @ApiModelProperty("审批状态(字典)")
    private String approveStatus;

    @ApiModelProperty("审批状态名称")
    private String approveStatusName;

    @ApiModelProperty("是否完全核销")
    private String isAllAudit;

    @ApiModelProperty("是否核销")
    private String isAudit;

    @ApiModelProperty("活动概述")
    private String actDesc;

    @ApiModelProperty("开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    private String endDateSecond;

    @ApiModelProperty("工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    private String workFlowName;

    @ApiModelProperty("申请金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("审批附件")
    private List<TpmActFileRespVo> fileList;

    @ApiModelProperty("预算信息")
    private List<TpmActBudgetRespVo> budgetVos;

    @ApiModelProperty("明细信息")
    private List<TpmActDetailRespVo> detailVos;

//    @ApiModelProperty("分摊信息")
//    private List<TmpActFeeShareRespVo> feeShareVos;

    @ApiModelProperty("编辑查看时,费用预算的集合数据")
    private List<TpmFeeBudgetControlRespVo> editBudgetVos;

//    @ApiModelProperty("活动大类编码")
//    private String categoriesCode;
//
//    @ApiModelProperty("活动大类名称")
//    private String categoriesName;

    @ApiModelProperty("预算编码")
    private String budgetCode;

    @ApiModelProperty("可用余额")
    private BigDecimal availableBalance;

    @ApiModelProperty("预算科目名称")
    private String budgetSubjectName;

//    @ApiModelProperty("活动大类对应的分摊信息")
//    private Map<String, List<TmpActFeeShareRespVo>> categoriesFeeShareMap;

}