package com.biz.crm.nebular.tpm.jiuact.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.act.req.TmpActFeeShareReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActFileReqVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 活动信息主表;请求vo
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "pmJiuActReqVo", description = "酒类活动信息主表;")
public class TpmJiuActReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动类型(字典)")
    private String actType;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("是否跨组织")
    private String isCrossOrg;

    @ApiModelProperty("责任组织")
    private String orgCode;

    @ApiModelProperty("客户")
    private String customerCode;

    @ApiModelProperty("组织名称")
    private String ogrName;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("审批状态(字典)")
    private String approveStatus;

    @ApiModelProperty("是否完全核销")
    private String isAllAudit;

    @ApiModelProperty("是否核销")
    @SaturnColumn(description = "是否核销")
    private String isAudit;

    @ApiModelProperty("活动概述")
    private String actDesc;

    @ApiModelProperty("开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    private String endDateSecond;

    @ApiModelProperty("工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    private String workFlowName;

    @ApiModelProperty("申请金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("审批附件")
    private List<TpmActFileReqVo> fileList;

    @ApiModelProperty("预算信息")
    private List<TpmActBudgetReqVo> budgetVos;

    @ApiModelProperty("编辑查看时,费用预算的集合数据")
    private List<TpmFeeBudgetControlRespVo> budgetControlVos;

    @ApiModelProperty("保存类型:1新增暂存,2,新增并提交审批,3,修改暂存,4修改并提交审批,5,提交审批")
    private String saveType;


    @ApiModelProperty("提交给审批流的附件集合")
    private List<TpmActFileReqVo> activityFileList;

    @ApiModelProperty("主题")
    private String title;

    @ApiModelProperty("审批备注")
    private String approveRemarks;

    @ApiModelProperty("不包含的编码集合(弹窗使用)")
    private List<String> notInCodeList;

    @ApiModelProperty("创建时间开始,筛选条件使用")
    private String createBeginDate;

    @ApiModelProperty("创建时间结束,筛选条件使用")
    private String createEndDate;


}