package com.biz.crm.nebular.sfa.assistant.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 工作总结 请求vo
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkSummaryReqVo", description = "工作总结 ")
public class SfaWorkSummaryReqVo extends CrmExtVo {

    @ApiModelProperty("开始时间")
    private String startDate;

    @ApiModelProperty("结束时间")
    private String overDate;

    @ApiModelProperty("当前用户")
    private String userCode;

    @ApiModelProperty("总结类型 1日报 2周报 3月报")
    private String summaryType;

    @ApiModelProperty("总结内容")
    private String content;

    @ApiModelProperty("工作计划")
    private String wordPlan;

    @ApiModelProperty("当前登录人所属的组织编码")
    private String presentOrgCode;

    @ApiModelProperty("查询的时间")
    private String queryDate;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("职位层级编码")
    private String positionCode;

    @ApiModelProperty("工作总结图片")
    private List<SfaWorkTaskPictureReqVo> pictureReqVos;

    @ApiModelProperty("年月")
    private String yearMonth;

}