package com.biz.crm.nebular.sfa.checkin.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 打卡类型;返回vo
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "打卡类型;")
@SaturnEntity(name = "SfaCheckInTypeRespVo", description = "打卡类型;")
public class SfaCheckInTypeRespVo {

    @ApiModelProperty("打卡类型ID")
    private String id;

    @ApiModelProperty("序号")
    @SaturnColumn(description = "序号")
    private String lineNo;

    @ApiModelProperty("类型名称")
    @SaturnColumn(description = "类型名称")
    private String typeName;

    @ApiModelProperty("是否拍照(Y是,N否)")
    @SaturnColumn(description = "是否拍照(Y是,N否)")
    private String photograph;

    @ApiModelProperty("是否拍照名称")
    private String photographName;

    @ApiModelProperty("是否指定时间(Y是,N否)")
    @SaturnColumn(description = "是否指定时间(Y是,N否)")
    private String appointTime;

    @ApiModelProperty("是否指定时间名称")
    private String appointTimeName;

    @ApiModelProperty("开始时间")
    @SaturnColumn(description = "开始时间")
    private String beginTime;

    @ApiModelProperty("结束时间")
    @SaturnColumn(description = "结束时间")
    private String endTime;

    @ApiModelProperty("备注")
    private String remarks;
}