package com.biz.crm.nebular.sfa.visitinfo.resp;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 拜访计划;返回vo
 *
 * @author Xiao
 * @date 2020-09-30 10:26:35
 */
@Data
@ApiModel(value = "拜访计划;")
public class SfaVisitPlanInfoRespVo extends CrmExtVo {

    @ApiModelProperty("拜访计划编码;拜访计划编码")
    private String visitPlanCode;

    @ApiModelProperty("人员账号;人员账号")
    private String visitUserName;

    @ApiModelProperty("人员姓名;人员姓名")
    private String visitRealName;

    @ApiModelProperty("人员职位编码;人员职位编码")
    private String visitPosCode;

    @ApiModelProperty("人员职位名称;人员职位名称")
    private String visitPosName;

    @ApiModelProperty("人员所属组织编码;人员所属组织编码")
    private String visitOrgCode;

    @ApiModelProperty("人员所属组织名称;人员所属组织名称")
    private String visitOrgName;

    @ApiModelProperty("上级组织编码")
    private String parentOrgCode;

    @ApiModelProperty("上级组织名称")
    private String parentOrgName;

    @ApiModelProperty("拜访日期;拜访日期yyyy-MM-dd")
    private String visitDate;

    @ApiModelProperty("拜访类型;拜访类型(临时拜访/计划拜访)")
    private String visitType;

    @ApiModelProperty("网点id;协访网点")
    private String clientId;

    @ApiModelProperty("网点编码;协访网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称;协访网点名称")
    private String clientName;

    @ApiModelProperty("网点类型;协访网点类型")
    private String clientType;

    @ApiModelProperty("网点类型;协访网点类型")
    @CrmDict(typeCode = "sfacusType",dictCodeField = "clientType")
    private String clientTypeDesc;

    @ApiModelProperty("网点地址")
    private String clientAddress;

    @ApiModelProperty("网点联系人")
    private String clientContacts;

    @ApiModelProperty("网点图片")
    private String clientPhoto;

    @ApiModelProperty("网点电话")
    private String clientPhone;

    @ApiModelProperty("经度;协访网点经度")
    private BigDecimal longitude;

    @ApiModelProperty("纬度;协访网点纬度")
    private BigDecimal latitude;

    @ApiModelProperty("距离hash值;协访网点hash值")
    private String geohash;

    @ApiModelProperty("距离;协访网点距离")
    private BigDecimal distance;

    @ApiModelProperty("拜访状态(0待处理1拜访中2已完成)")
    private String visitStatus;

    @ApiModelProperty("拜访状态(0待处理1拜访中2已完成)")
    @CrmDict(typeCode = "visit_status",dictCodeField = "visitStatus")
    private String visitStatusDesc;

    @ApiModelProperty("按钮名称(0待处理1拜访中2已完成)")
    private Map<String,String> buttons;

    @ApiModelProperty("经销商拜访中id")
    private String visitDealerDetailId;

}