package com.biz.crm.nebular.sfa.visitstep.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepIconReqVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 拜访步骤表单-新增编辑
 * @author YuanZiJian
 * @date 2021/2/5 12:34
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤表单-查询")
@SaturnEntity(name = "SfaVisitStepFromRespVo", description = "拜访步骤表单-查询")
public class SfaVisitStepFromRespVo {
    @ApiModelProperty("步骤表单Id")
    private String id;
    /**
     * 步骤表单名称
     */
    @ApiModelProperty("步骤表单名称")
    private String fromName;
    /**
     * 拜访类型
     */
    @ApiModelProperty("拜访类型")
    private String visitType;
    /**
     * 拜访类型名称 查询用！！
     */
    @ApiModelProperty("拜访类型名称——查询用！！")
    @CrmDict(typeCode = "sfaVisitType",dictCodeField = "visitType")
    private String visitTypeName;

    /**
     * 客户类型
     */
    @ApiModelProperty("客户类型")
    private String customerType;

    /**
     * 客户类型名称 查询用！！
     */
    @ApiModelProperty("客户类型名称——查询用！！")
    @CrmDict(typeCode = "sfacusType",dictCodeField = "customerType")
    private String customerTypeName;
    /**
     * 有效期类型
     */
    @ApiModelProperty("有效期类型")
    private String timeType;
    /**
     * 有效期类型名称 查询用！！
     */
    @ApiModelProperty("有效期类型——查询用！！")
    @CrmDict(typeCode = "timeType",dictCodeField = "timeType")
    private String timeTypeName;
    /**
     * 有效期开始时间
     */
    @ApiModelProperty("有效期开始时间")
    private String startTime;
    /**
     * 有效期结束时间
     */
    @ApiModelProperty("有效期结束时间")
    private String endTime;
    /**
     * 步骤logo
     */
    @ApiModelProperty("步骤logo")
    private List<SfaVisitStepIconRespVo> icon;
    /**
     * 页面编码——（模板）
     */
    @ApiModelProperty("页面编码——（即模板）")
    private String pageCode;
    /**
     * 页面编码名称——（模板名称）查询用！！
     */
    @ApiModelProperty("页面编码名称——（模板名称）查询用！！")
    @CrmDict(typeCode = "sfa_visit_step",dictCodeField = "pageCode")
    private String pageCodeName;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("拜访步骤模块-新增编辑Vo")
    private List<SfaVisitStepFromModelRespVo> stepFromModelRespVoList;

}
