package com.biz.crm.nebular.sfa.actscheme.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 方案活动申请;请求vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaActSchemePosApplyReqVo", description = "方案活动申请;")
public class SfaActSchemePosApplyReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("方案编码")
    private String schemeCode;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("活动类型")
    private String activityType;

    @ApiModelProperty("门店类型")
    private String terminalType;

    @ApiModelProperty("门店类型集合")
    private List<String> terminalTypeList;

    @ApiModelProperty("OA核销号")
    private String oaAuditCode;

    @ApiModelProperty("活动费用")
    private String actCostAmount;

    @ApiModelProperty("计划销量")
    private String planSalesVolume;

    @ApiModelProperty("单箱成本")
    private String singleCost;

    @ApiModelProperty("陈列类型")
    private String displayType;

    @ApiModelProperty("陈列类型集合")
    private List<String> displayTypeList;

    @ApiModelProperty("计划投入门店数量")
    private String planTermNum;

    @ApiModelProperty("兑付方式")
    private String paymentMethod;

    @ApiModelProperty("活动执行开始时间")
    private String activityStartTime;

    @ApiModelProperty("活动执行结束时间")
    private String activityEndTime;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("状态")
    private String bpmState;

    @ApiModelProperty("活动结案状态(0:未结案；1：结案)")
    public String endCaseState;

    @ApiModelProperty("是否提交(1 是;0 否)")
    private String isSubmit;

}