package com.biz.crm.nebular.sfa.asexecution.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

/**
 * 方案活动执行产品数据采集;请求vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaAsExecutionProductReqVo", description = "方案活动执行产品数据采集;")
public class SfaAsExecutionProductReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("执行id")
    private String executionId;

    @ApiModelProperty("方案套餐id")
    private String setmealId;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("数量")
    private BigInteger productNum;

    @ApiModelProperty("价格")
    private BigDecimal price;

}