package com.biz.crm.nebular.sfa.asexecution.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * 方案活动执行产品数据采集;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "方案活动执行产品数据采集;")
@SaturnEntity(name = "SfaAsExecutionProductRespVo", description = "方案活动执行产品数据采集;")
public class SfaAsExecutionProductRespVo extends CrmExtTenVo {

    @ApiModelProperty("执行id")
    @SaturnColumn(description = "执行id")
    private String executionId;

    @ApiModelProperty("方案套餐id")
    @SaturnColumn(description = "方案套餐id")
    private String setmealId;

    @ApiModelProperty("产品编码")
    @SaturnColumn(description = "产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    @SaturnColumn(description = "产品名称")
    private String productName;

    @ApiModelProperty("数量")
    @SaturnColumn(description = "数量")
    private BigInteger productNum;

    @ApiModelProperty("价格")
    @SaturnColumn(description = "价格")
    private BigDecimal price;
}