package com.biz.crm.nebular.sfa.worksign.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 异常报备申请 请求vo
 *
 * @author ren.gang
 * @date 2020-11-23 15:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaExceptionReportReqVo", description = "异常报备申请 Vo ")
public class SfaExceptionReportReqVo {

    @ApiModelProperty("主键id-修改用")
    private String id;

    @ApiModelProperty("异常说明 异常说明")
    private String reportReason;

    @ApiModelProperty("开始时间 开始时间(yyyy-MM-dd HH)")
    private String beginTime;

    @ApiModelProperty("结束时间 结束时间(yyyy-MM-dd HH)")
    private String endTime;

    @ApiModelProperty("附件集合")
    private List<SfaApplyAttachmentReqVo> attachmentList;

    @ApiModelProperty("打卡记录ID")
    private List<String> workSignRecordIdList ;

}