package com.biz.crm.nebular.tpm.audit.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 核销申请主表 请求vo
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmAuditReqVo", description = "核销申请主表 ")
public class TpmAuditReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("核销申请名称")
    private String auditName;

    @ApiModelProperty("核销申请编码")
    private String auditCode;

    @ApiModelProperty("审批状态(字典)")
    private String approveStatus;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    private String workFlowName;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("核销明细入参")
    private List<TpmAuditDetailReqVo> detailVos;

    @ApiModelProperty("活动数据入参")
    private List<TpmAuditActReqVo> tpmAuditActReqVos;

    @ApiModelProperty("保存类型:1新增暂存,2,新增并提交审批,3,修改暂存,4修改并提交审批,5,提交审批")
    private String saveType;

    @ApiModelProperty("核销资料入参")
    private List<TpmAuditFileRespVo> auditFileRespVos;

    @ApiModelProperty("审批文件集合")
    private List<TpmAuditFileRespVo> activityFileReqVos;

    @ApiModelProperty("是否需要占用预算")
    private Boolean occupyFeeBudgetFlag=false;

    @ApiModelProperty("需要占用预算的明细集合")
    private List<TpmAuditDetailReqVo> occupyFeeBudgetDetails;

    @ApiModelProperty("审批主题")
    private String title;

    @ApiModelProperty("审批备注")
    private String approveRemarks;

    @ApiModelProperty("创建时间开始,筛选条件使用")
    private String createBeginDate;

    @ApiModelProperty("创建时间结束,筛选条件使用")
    private String createEndDate;
}