package com.biz.crm.nebular.activiti.listener.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @CLASS_DESCRIBE: 流程监听配置表 响应vo
 * @AUTHOR: create by zkey on 2020-11-02
 */
@Data
@Builder
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActivitiListenerRespVo", description = "流程监听vo")
@CrmColumnResolve
public class ActivitiListenerRespVo extends PageVo {

    @ApiModelProperty("监听名称")
    @SaturnColumn(description = "监听名称")
    private String listenerName;//监听名称

    @ApiModelProperty("监听类路径")
    @SaturnColumn(description = "监听类路径")
    private String className;//监听类路径

    @ApiModelProperty("监听类型")
    @SaturnColumn(description = "监听类型")
    private String listenerType;//监听类型

    @ApiModelProperty("事件类型")
    @SaturnColumn(description = "事件类型")
    private String event;//事件类型

    @ApiModelProperty("表达式")
    @SaturnColumn(description = "表达式")
    private String expression;//表达式

    /**
     * 数据业务状态（启用状态）
     */
    @ApiModelProperty("生效状态")
    @SaturnColumn(description = "生效状态")
    private String enableStatus;

    /**
     * 数据业务状态名称（启用状态）
     */
    @ApiModelProperty("生效状态名称")
    @SaturnColumn(description = "生效状态名称")
    @CrmDict(typeCode = "enable_status",dictCodeField = "enableStatus")
    private String enableStatusName;
}
