package com.biz.crm.nebular.sfa.asexecution.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigInteger;

/**
 * 方案活动协议-货物兑换产品;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "方案活动协议-货物兑换产品;")
@SaturnEntity(name = "SfaAsExecutionRespVo", description = "方案活动协议-货物兑换产品;")
public class SfaAsTreatyConvertProductRespVo extends CrmExtTenVo {

    @ApiModelProperty("协议id")
    @SaturnColumn(description = "协议id")
    private String treatyId;

    @ApiModelProperty("产品编码")
    @SaturnColumn(description = "产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    @SaturnColumn(description = "产品名称")
    private String productName;

    @ApiModelProperty("数量")
    @SaturnColumn(description = "数量")
    private BigInteger productNum;

    @ApiModelProperty("行类型(1:支付货品;2:奖励货品)")
    @SaturnColumn(description = "行类型(1:支付货品;2:奖励货品)")
    private String itemType;
}